#!/usr/bin/env python
# 日経平均株価
import urllib.request
from bs4 import BeautifulSoup
import datetime
import sqlite3
import csv
import sys
import os
# url,db,ファイル,パラメータ値
url = 'https://finance.stockweather.co.jp/contents/marketdetail.aspx?cntcode=JP&skubun=0&stkcode=54&exctype=02'
database = 'nikkei.db'
dst_file = 'nikkei.csv'
log_file = 'nikkei.log'
log_txt = ''
Err_txt = ''
f_encoding = 'utf-8'  # shift-jis
date_time = str(datetime.datetime.now())
# SQL
sql_create = """
CREATE TABLE IF NOT EXISTS nk225_day (
    Trading_day TEXT(10),
    Open REAL,
    High REAL,
    Low REAL,
    Close REAL,
    The_day_before REAL,
    The_day_before_rate REAL,
    Prev_close REAL,
    Yearly_high REAL,
    Yearly_low REAL,
    PRIMARY KEY(Trading_day));
"""
sql_insert = """
REPLACE INTO nk225_day (
    Trading_day,
    Open,
    High,
    Low,
    Close,
    The_day_before,
    The_day_before_rate,
    Prev_close,
    Yearly_high,
    Yearly_low)
values (?,?,?,?,?,?,?,?,?,?);
"""
# 本処理
try:
    # 日経平均株価取得＆編集
    soup = BeautifulSoup(urllib.request.urlopen(url), 'html.parser')
    time = soup.find(class_='time')
    Trading_day_list = time.text.split(" ", 1)
    Trading_day = Trading_day_list[0]
    td = soup.find_all('td')
    Close_list = td[0].text.replace(',', '').split("(", 1)
    Close = Close_list[0]
    The_day_before_list = td[1].text.replace(',', '')
    The_day_before_list = The_day_before_list.replace('+', '')
    The_day_before_list = The_day_before_list.replace(' %）', '').split("（", 1)
    The_day_before = float(The_day_before_list[0])
    The_day_before_rate = float(The_day_before_list[1])
    Open = float(td[2].text.replace(',', ''))
    High = float(td[3].text.replace(',', ''))
    Low = float(td[4].text.replace(',', ''))
    Prev_close = float(td[5].text.replace(',', ''))
    Yearly_high = float(td[6].text.replace(',', ''))
    Yearly_low = float(td[7].text.replace(',', ''))
    '''
    print('日経平均データ取得スクリプト')
    print('スクリプト実行時刻:', date_time)
    print('取引日:', Trading_day)
    print('始値:', Open, sep='')
    print('高値:', High, sep='')
    print('安値:', Low, sep='')
    print('終値:', Close, sep='')
    print('前日比:', The_day_before, sep='')
    print('前日比(%):', The_day_before_rate, sep='')
    print('前日終値:', Prev_close, sep='')
    print('年初来高値:', Yearly_high, sep='')
    print('年初来安値:', Yearly_low, sep='')
    '''
    index = ('取引日', '始値', '高値', '安値', '終値', '前日比', '前日比(%)', '前日終値', '年初来高値', '年初来安値')
    data = (Trading_day, Open, High, Low, Close, The_day_before, The_day_before_rate, Prev_close, Yearly_high, Yearly_low)
    # DB書き込み
    conn = sqlite3.connect(database, isolation_level=None)
    conn.execute(sql_create)
    conn.execute(sql_insert, data)
    conn.close
    # CSVファイル書き込み（書き込みレコードが最終レコードと同一日付データの時は書き込まない）
    if os.path.exists(dst_file) is False:  # ファイルが存在しない場合、CSVヘッダーレコードを書き込み
        with open(file=dst_file, mode='w', encoding='shift-jis', newline='') as f:  # newline='' -> 指定しないと一行空く
            writer = csv.writer(f)
            writer.writerow(index)  # ヘッダー書き込み
#        print('Create new file')
    with open(file=dst_file, mode='r', encoding='shift-jis', newline='') as f:  # ファイル読込
        reader = csv.reader(f)
        for row in reader:  # list rowに最終レコードを格納する
            pass  # 空処理
    if row[0] != Trading_day:  # 最終レコードの日付と異なるときのみ書き込みを行う
        with open(file=dst_file, mode='a', encoding='shift-jis', newline='') as f:
            writer = csv.writer(f)
            writer.writerow(data)  # データ書き込み
#            print('New record add')
    # 正常終了ログ作成
    log_txt = date_time + ',OK\n'
# 例外処理
except Exception as e:
    # 行番号取得
    exc_type, exc_obj, traceback = sys.exc_info()
    lineno = traceback.tb_lineno
    # エラーログ作成
    log_txt = date_time + ',Error Line:' + str(lineno) + ":" + str(e) + '\n'
# 終了処理
finally:
    # ログ出力
    with open(file=log_file, mode='a', encoding=f_encoding) as f:
        f.write(log_txt)
#    print(log_txt)
